/* jAlbum core update */

import se.datadosen.jalbum.*;
import se.datadosen.component.*;
import se.datadosen.util.*;

class RenameDeniedException extends PermissionDeniedException {

    public RenameDeniedException(String message) {
        super(message);
    }    
}

/**
 * For our auto-updates
 * Throws PermissionDeniedException if underlying file system prevents writing to disk
 */
void grabFile(URL url, File dest) throws PermissionDeniedException, IOException {
    FileOutputStream fos;
    try {
        fos = new FileOutputStream(dest);
    }
    catch (IOException ex) {
        throw new PermissionDeniedException("Critical update available. Please restart jAlbum as administrator to begin update", ex);
    }
    try {
	    IO.downloadFile(url, fos);
    }
    finally {
    	fos.close();
    }
}

/**
 * Handle file download and file renaming if download was successful
 */
void updateFile(URL url, File destDir) throws PermissionDeniedException, IOException {
    String path = url.getPath();
    String fileName = path.substring(path.lastIndexOf('/')+1);
    File downloading = new File(destDir, fileName + ".downloading");
    File downloaded = new File(destDir, fileName + ".downloaded");
    System.out.println("Updating " + fileName + " ...");
    grabFile(url, downloading);
    System.out.println("Done");
    downloading.renameTo(downloaded);
    
    if (!fileName.endsWith(".jar") && !fileName.endsWith(".zip")) {
        File oldFile = new File(destDir, fileName + ".old");
        File destFile = new File(destDir, fileName);

        if (destFile.exists()) {
            if (oldFile.exists()) {
                oldFile.delete();
            }
            destFile.renameTo(oldFile);
        }
        if (downloaded.renameTo(destFile)) {
//                System.out.println("Installed update of " + destFile);
            oldFile.delete();
        };            
    }
}


msg =
"This tool will download and install the most recent (unofficial)\n" +
"update to jAlbum's core code (jalbum-core.jar)\n" +
"Do you wish to continue?";

	int answer = JOptionPane.showConfirmDialog(
	        window,
	        msg,
	        "jAlbum core update",
	        JOptionPane.YES_NO_OPTION,
	        JOptionPane.WARNING_MESSAGE);
	
	if (answer != JOptionPane.YES_OPTION) {
	    return;
	}
	
	try {
		File libDir = new File(Config.getConfig().progDir, "lib");
		window.statusBar.pushText("Downloading update");
		window.progressSpinner.workStarted();

		updateFile(new URL("http://jalbum.net/download/" +AlbumBean.getDisplayVersion() + "/jalbum-core.jar"), libDir);
	    JNotification note = new JNotification("Update installed. Please restart jAlbum as administrator to complete update", JNotification.Type.TIP);
	    note.setPriority(JNotification.Priority.HIGH);
	    window.showNotification(note); 	
	}
    catch (PermissionDeniedException ex) {
        JNotification tip = new JNotification(ex.getMessage(), JNotification.Type.TIP);
        tip.setPriority(JNotification.Priority.HIGH);
        window.showNotification(tip);            
    }
    catch (FileNotFoundException ex) {
        JOptionPane.showMessageDialog(window, "No core update currently available", "jAlbum core update", JOptionPane.INFORMATION_MESSAGE);
    }
    catch (Exception ex) {
        Debug.showErrorDialog(window, ex);
    }
    finally {
		window.statusBar.popText("Downloading update");
		window.progressSpinner.workDone();
    }
	
